#install.packages("ggpubr")

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")


#library packages
library(limma)
library(ggpubr)
gene="TAGLN2"            #standard names of genes
showName="TAGLN2"        #Gene names shown in the plot
expFile="TAGLN2.txt"      #expression data file
clusterFile="group.txt"     #cluster cluster file
setwd("C:\\Users\\Lenovo\\Desktop\\metabolism\\metabolism\\LGG\\18.SA_chort")      

#Read expression data file
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
data=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)
data=avereps(data)


#Extract target gene expression
data=rbind(data, gene=data[gene,])
exp=t(data[c("gene",gene),])
exp=avereps(exp)

#Read the cluster cluster file
cluster=read.table(clusterFile, header=T, sep="\t", check.names=F, row.names=1)
	
#data merge
sameSample=intersect(row.names(exp), row.names(cluster))
exp=exp[sameSample,]
exp[exp>quantile(exp,0.975)]=quantile(exp,0.975)
cluster=cluster[sameSample,]
data=cbind(as.data.frame(exp), as.data.frame(cluster))
	
#Set up the comparison cluster
data$group=factor(data$cluster, levels=c("Normal", "Tumor"))
group=levels(factor(data$group))
comp=combn(group,2)
my_comparisons=list()
for(i in 1:ncol(comp)){my_comparisons[[i]]<-comp[,i]}
	
#plot a boxplot
boxplot=ggboxplot(data, x="group", y="gene", fill="group",
			      xlab="",
			      ylab="LFQ value of quantified protein",
			      legend.title="group",
			      palette=c("#435E97","#E7C169"))+ 
	stat_compare_means(comparisons = my_comparisons)
	
#output plot
pdf(file=paste0(gene, ".pdf"), width=3, height=2.5)
print(boxplot)
dev.off()

